package com.ejie.ab18a.service;

import java.util.List;

import com.ejie.ab18a.entidades.Ab18aUsuario;
import com.ejie.ab18a.model.Ab18aEnvio;
import com.ejie.ab18a.model.Ab18aFiltroMonitor;
import com.ejie.ab18a.model.Ab18aIncoherencia;
import com.ejie.ab18a.model.Ab18aPeticionDetalle;
import com.ejie.ab18a.model.Ab18aPeticionEnvio;
import com.ejie.ab18a.ws.model.Ab18aDatosRespuestaEsentool;
import com.ejie.ab18a.ws.model.Ab18aValidacionBoletin;
import com.ejie.ab18a.ws.model.DatosBoletin;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab18a01s00Service generated by XXXX, 03-feb-2017 12:08:05.
 * 
 * @author XXXX
 */

public interface Ab18aPeticionEnvioService {

	Ab18aPeticionEnvio findIfExists(Ab18aPeticionEnvio peticionAux) throws Exception;

	/**
	 * Inserts a single row in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @return Ab18a01s00
	 * @throws Exception
	 */
	Ab18aPeticionEnvio add(Ab18aPeticionEnvio ab18a01s00) throws Exception;

	/**
	 * Updates a single row in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @return Ab18a01s00
	 */
	Ab18aPeticionEnvio update(Ab18aPeticionEnvio ab18a01s00);

	/**
	 * Finds a single row in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @return Ab18a01s00
	 */
	DatosBoletin findPeticionRecogida(Ab18aPeticionEnvio ab18a01s00);

	/**
	 * Finds a single row in the Ab18a01s00 table.
	 * 
	 * @param idPeticionEnvio
	 *            id de la peticion de envio
	 * @return Ab18aDatosRespuestaEsentool
	 */
	Ab18aDatosRespuestaEsentool findRespuestaWS(Integer idPeticionEnvio);

	/**
	 * Finds a single row in the Ab18a01s00 table.
	 * 
	 * @param idPeticionEnvio
	 *            id de la peticion de envio
	 * @return Ab18aDatosRespuestaEsentool
	 */
	List<String> findTedLinks(Integer idPeticionEnvio);

	/**
	 * Finds a list of rows in the Ab18a09s00 table.
	 * 
	 * @param idPeticionEnvio
	 *            id de la peticion de envio
	 * @return Ab18aValidacionBoletin
	 */
	List<Ab18aValidacionBoletin> findValidaciones(Integer idPeticionEnvio);

	/**
	 * Finds a single row in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @return Ab18a01s00
	 */
	Ab18aPeticionEnvio find(Ab18aPeticionEnvio ab18a01s00);

	/**
	 * Deletes a single row in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 */
	void remove(Ab18aPeticionEnvio ab18a01s00);

	/**
	 * Finds a list of rows in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a01s00>
	 */
	List<Ab18aPeticionEnvio> findAll(Ab18aPeticionEnvio ab18a01s00, JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Ab18a01s00 table using like.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a01s00>
	 */
	List<Ab18aPeticionEnvio> findAllLike(Ab18aPeticionEnvio ab18a01s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	List<Ab18aEnvio> findPeticionesCuadro(Ab18aFiltroMonitor filtroMonitor, Ab18aUsuario usuario, JQGridRequestDto jqGridRequestDto);

	Long findAllCount(Ab18aFiltroMonitor filtroMonitor, Ab18aUsuario usuario);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab18a01s00 table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Ab18aPeticionEnvio filterAb18a01s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Filter method in the Ab18a01s00 table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Ab18a01s00>
	 */
	JQGridResponseDto<Ab18aPeticionEnvio> filter(Ab18aPeticionEnvio filterAb18a01s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Ab18a01s00 table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param searchAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a01s00>>
	 */
	List<TableRowDto<Ab18aPeticionEnvio>> search(Ab18aPeticionEnvio filterAb18a01s00, Ab18aPeticionEnvio searchAb18a01s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in Ab18a01s00 table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(Ab18aPeticionEnvio filterAb18a01s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab18a01s00 table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a01s00>>
	 */
	JQGridResponseDto<JerarquiaDto<Ab18aPeticionEnvio>> jerarquia(Ab18aPeticionEnvio filterAb18a01s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Ab18a01s00 table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a01s00>>
	 */
	JQGridResponseDto<JerarquiaDto<Ab18aPeticionEnvio>> jerarquiaChildren(Ab18aPeticionEnvio filterAb18a01s00, JQGridRequestDto jqGridRequestDto);

	DatosBoletin findPeticionById(Integer idPeticionEnvio);

	Ab18aPeticionEnvio findZipById(Integer idPeticionEnvio);

	void paralizarReanudarPeticion(Integer idPeticion, Integer valorParalizar) throws Exception;

	List<Ab18aIncoherencia> findIncoherencias(Ab18aIncoherencia filtroIncoherencia, Ab18aUsuario usuario, JQGridRequestDto jqGridRequestDto);

	Long findAllCountIncoherencias(Ab18aIncoherencia filtroIncoherencias, Ab18aUsuario usuario);

	void deshabilitarIncoherencia(String codExpediente);

	Ab18aPeticionDetalle findDetallePeticionById(Integer idPeticion) throws Exception;

	void reactivar(Integer idPeticion) throws Exception;

	Integer findNumIntentosById(Integer idPeticion) throws Exception;
}
